<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class LibraryFile extends Model 
{

    protected $table = 'library_file';
    public $timestamps = true;
    protected $guarded = array('md5');
    protected $fillable = array('node_id', 'source', 'library_storage_file_id', 'url', 'name', 'ext', 'size', 'mime');

    public function componentPlaylistItems()
    {
        return $this->hasMany('App\Models\ComponentPlaylistItem');
    }

    public function contentSimpleItems()
    {
        return $this->hasMany('App\Models\ContentSimpleItem');
    }

    public function node()
    {
        return $this->belongsTo('App\Models\Node');
    }

    public function libraryStorageFile()
    {
        return $this->belongsTo('App\Models\LibraryStorageFile');
    }

    public function libraryFileCategories()
    {
        return $this->hasMany('App\Models\LibraryFileCategory');
    }

    public function libraryFileMetas()
    {
        return $this->hasMany('App\Models\LibraryFileMeta');
    }

    public function albumart()
    {
        return $this->belongsTo('App\Models\Albumart');
    }

}